//
//  MCReportAbstractArrayEditor.h
//  MCReporting
//
//  Created by Alykhan Jetha on 11/02/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCWindowController.h>

@class MCReportDataInfo;
@class MCReportDataInfoPlugin;
@class MCTVToolbarView;
@class MCReportElement;

@interface MCReportAbstractArrayEditor : MCWindowController {
	
	MCReportElement *reportElement;
	
	MCReportDataInfo *originalDataInfo;
	MCReportDataInfoPlugin *originalDataInfoPlugin;
	
	MCReportDataInfo *dataInfo;
	MCReportDataInfoPlugin *currentDataInfoPlugin;
	
	IBOutlet NSArrayController *resultingFieldsAC;
	IBOutlet MCTVToolbarView *tvToolbar;

	
	id delegate;
	
	BOOL didRegisterForUndo;

}

- (void)setReportElement:(MCReportElement *)aReportElement dataInfo:(MCReportDataInfo *)aDataInfo andDataInfoPlugin:(MCReportDataInfoPlugin *)aPlugin;

- (BOOL)customFieldsEditable;
- (void)updateResultingFieldsArrayController;

- (MCReportDataInfo *)originalDataInfo;
- (void)setOriginalDataInfo:(MCReportDataInfo *)anOriginalDataInfo;

- (MCReportDataInfoPlugin *)originalDataInfoPlugin;
- (void)setOriginalDataInfoPlugin:(MCReportDataInfoPlugin *)anOriginalDataInfoPlugin;

- (MCReportDataInfo *)dataInfo;
- (void)setDataInfo:(MCReportDataInfo *)aDataInfo;

- (MCReportDataInfoPlugin *)currentDataInfoPlugin;
- (void)setCurrentDataInfoPlugin:(MCReportDataInfoPlugin *)aCurrentDataInfoPlugin;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

// subclasses must implement this if they set ivars and call super!
- (void)cleanup;

// registers for undo
- (void)willOk:(id)sender;

// subclasses must call super after they are done
- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;


@end

@interface NSObject (MCReportAbstractArrayEditorDelegate)
- (void)arrayDataSourceEditorDidGetOk:(MCReportAbstractArrayEditor *)anEditor;
- (void)arrayDataSourceEditorDidGetCancel:(MCReportAbstractArrayEditor *)anEditor;
@end
